function [Fitresult] = psyCurvePlot(SubResult)
%UNTITLED9 此处提供此函数的摘要
%   此处提供详细说明



FitResult=[];
%% 拟合数据
for i=1:length(SubResult)
    x=SubResult{i}.StiContrastList/255*100;
    y=SubResult{i}.AwarePercent'*100;
    n=SubResult{i}.StiContrastNum';
    figure
[fitresult, gof]=createFits_bin(x,y);
% hold off
% saveas(gcf,strcat('psyCurve',num2str(i)),'tif')
% saveas(gcf,strcat('psyCurve',num2str(i)),'fig')
% pause
% close
% 用拟合数据求阈限值
xtemp=0:0.01:max(x);
ytemp = feval(fitresult,xtemp);
[perc,thresholdIndex]=min(abs(ytemp-50)); %离50%最近的点
threshold=xtemp(thresholdIndex);

FitResult(i).fitresult=fitresult;
FitResult(i).gof=gof;
FitResult(i).threshold=threshold;


end

%% 合并不同session数据
% Py=NaN(length(SubResult),26);  %标准化觉知比例
% Pn=NaN(length(SubResult),26);  
% Px=NaN(length(SubResult),26);  

Py=NaN(length(SubResult),50);  %标准化觉知比例
Pn=NaN(length(SubResult),50);  
Px=NaN(length(SubResult),50);  

% edges = [-5 -2:0.25:2 10];
for i=1:length(SubResult)  %不同session
    x=SubResult{i}.StiContrastList/255*100;
    y=SubResult{i}.AwarePercent*100;
    n=SubResult{i}.StiContrastNum;
    threshold=FitResult(i).threshold;
    Sx=x-threshold;
    [~,index]=min(abs(Sx));
    iniIndex=round(size(Px,2)/2)-index+1;
   index2=iniIndex:(iniIndex+size(Sx,2)-1);
   Px(i,index2)=Sx;
   Py(i,index2)=y;
   Pn(i,index2)=n;

%     Sx1=Sx(2:end-1);
%     Sy1=y(2:end-1);
%     Sn1=n(2:end-1);
%     h=histogram(Sx1,nbins);
%     for j=1:nbins       %不同bin
%         temp=h.BinEdges;
%         index1=find(Sx1>=temp(j) & Sx1<temp(j+1));
%         contratemp=Sx1(index1);
%         aptemp=Sy1(index1);
%         numtemp=Sn1(index1);
%         binData.ap(i,j+1)=mean(aptemp);
%         binData.contra(i,j+1)=j;
%         binData.num(i,j+1)=sum(numtemp,'all');
%         
%     end
%     binData.ap(i,[1 j+2])=[y(1) y(end)];
%     binData.contra(i,[1 j+2])=[Sx(1) Sx(end)];
%     binData.num(i,[1 j+2])=[n(1) n(end)];        
end

% y=mean(Py,'omitnan');
% x=mean(Px,'omitnan');
% n=sum(Pn,'omitnan');
% createFits_bin(x,y)

% [Pxmin,index]=min(Px,[],2,'omitnan');
% Px(:,1)=Pxmin;
% Py(:,1)=Py(index);
% Pn(:,1)=Pn(index);
% Px(1:end,index)=NaN;
% Py(1:end,index)=NaN;
% Pn(1:end,index)=NaN;


Px1=Px(:);
Py1=Py(:);
Pn1=Pn(:);
index=isnan(Px1);
Px1(index)=[];
Py1(index)=[];
Pn1(index)=[];
[~,index]=sortrows(Px1,'ascend');
Px2=Px1(index);
Py2=Py1(index);
Pn2=Pn1(index);


nbins=6;
nsession=length(SubResult);
h=histogram(Px2(nsession+1:end-nsession),nbins);
binData=[];
for j=1:nbins       %不同bin
    temp=h.BinEdges;
    index1=find(Px2>=temp(j) & Px2<temp(j+1));
    contratemp=Px2(index1);
    aptemp=Py2(index1);
    numtemp=Pn2(index1);
    binData.ap(1,j)=mean(aptemp);
    binData.ap(2,j)=std(aptemp)./sqrt(length(aptemp)-1);  %sem
    binData.contra(1,j)=mean(contratemp);
    binData.num(1,j)=sum(numtemp,'all');
   
end
x= [mean(Px2(1:nsession)) binData.contra mean(Px2(end-nsession+1:end))];
y=[mean(Py2(1:nsession)) binData.ap(1,:) mean(Py2(end-nsession+1:end))];
n=[sum(Pn2(1:nsession)) binData.num(1,:) sum(Pn2(end-nsession+1:end))];
ye=[std(Py2(1:nsession))./sqrt(nsession-1) binData.ap(2,:) std(Py2(end-nsession+1:end))./sqrt(nsession-1)];
figure
[fitresult, gof]=createFits_bin(x, y);
hold on
errorbar(x,y,ye,...
    'CapSize',0,'LineWidth',1.5,'LineStyle','none','Color',[0 0 0]);
hold off
ax=gca;
ax.FontSize=18;
ax.LineWidth=1.5;
xlim([min(x),max(x)])
title(strcat('n=',num2str(nsession)))
saveas(gcf,strcat('Pop_psyCurve'),'tif')
saveas(gcf,strcat('Pop_psyCurve'),'fig')
Fitresult.fitresult=fitresult;
Fitresult.gof=gof;
Fitresult.x=x;
Fitresult.y=y;
Fitresult.n=n;
close
end